#include <iostream>
#include <windows>

#define cbInQueue 1024
#define cbOutQueue 1024

  using namespace std;

  void* hCommDev;
  DCB   dcb;
  COMMTIMEOUTS commTimeouts;

  //-----prototypy funkcji--------
  void closeSerialPort();
  int readSerialPort(void *buffer, unsigned long numberOfBytesToRead);
  int writeSerialPort(void *buffer, unsigned long numberOfBytesToWrite);
  bool openSerialPort(const char* portName);
  bool setCommTimeouts(unsigned long ReadIntervalTimeout,
                       unsigned long ReadTotalTimeoutMultiplier,
                       unsigned long ReadTotalTimeoutConstant,
                       unsigned long WriteTotalTimeoutMultiplier,
                       unsigned long WriteTotalTimeoutConstant);
  bool setTransmissionParameters(unsigned long BaudRate,int ByteSize,
                                unsigned long fParity,int Parity,
                                int StopBits);
//---------------------------------------------------------
int main()
{
  openSerialPort("COM9"); //wirtualny port szeregowy COM9
  setTransmissionParameters(CBR_9600, 8, true, ODDPARITY, ONESTOPBIT);
  setCommTimeouts(0xFFFFFFFF, 10, 0, 10, 0);
  char bufferIn[24];
  char bufferOut[64] = {0};

  char *text;
  //text = "ATI\r";  //przykadowe komendy AT
  text = "AT+CCLK?\r";
  strcpy(bufferIn, text);
  writeSerialPort(bufferIn, strlen(bufferIn));

  cout << "Otrzymano bajtow: " << readSerialPort(bufferOut,
                                                 sizeof(bufferOut))\
  << endl;
  cout << bufferOut;

  closeSerialPort();
  system("PAUSE");
  return 0;
}
//----ciaa funkcji----------------------------
bool openSerialPort(const char* portName)
{
  hCommDev = CreateFile(portName,GENERIC_READ | GENERIC_WRITE, 0,
                        NULL,OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL |
                        FILE_FLAG_OVERLAPPED, NULL);
  if(hCommDev==INVALID_HANDLE_VALUE){
     cout <<"Bd otwarcia portu " << portName << \
            " lub port jest aktywny.\n";
    return false;
  }
    else SetupComm(hCommDev, cbOutQueue, cbOutQueue);
      return true;
}
//---------------------------------------------------------
bool setTransmissionParameters(unsigned long BaudRate,
                               int ByteSize, unsigned long
                               fParity, int Parity, int StopBits)
{
  dcb.DCBlength = sizeof(dcb);
  GetCommState(hCommDev, &dcb);
  dcb.BaudRate =BaudRate;
  dcb.ByteSize = ByteSize;
  dcb.Parity =Parity ;
  dcb.StopBits =StopBits;
  dcb.fBinary=true;
  dcb.fParity=fParity;
  //...
  if(SetCommState(hCommDev, &dcb) == 0){
     cout << "Bd wykonania funkcji SetCommState()\n";
     CloseHandle(hCommDev);
     return false;
  }
  return true;
}
//---------------------------------------------------------
bool setCommTimeouts(unsigned long ReadIntervalTimeout,
                     unsigned long ReadTotalTimeoutMultiplier,
                     unsigned long ReadTotalTimeoutConstant,
                     unsigned long WriteTotalTimeoutMultiplier,
                     unsigned long WriteTotalTimeoutConstant)
{
  if(GetCommTimeouts(hCommDev, &commTimeouts) == 0)
     return false;
  commTimeouts.ReadIntervalTimeout = ReadIntervalTimeout;
  commTimeouts.ReadTotalTimeoutConstant = ReadTotalTimeoutConstant;
  commTimeouts.ReadTotalTimeoutMultiplier = ReadTotalTimeoutMultiplier;
  commTimeouts.WriteTotalTimeoutConstant =  WriteTotalTimeoutConstant;
  commTimeouts.WriteTotalTimeoutMultiplier = WriteTotalTimeoutMultiplier;

  if (SetCommTimeouts(hCommDev, &commTimeouts) == 0) {
     cout << "Bd wykonania funkcji SetCommTimeouts()\n";
     CloseHandle(hCommDev);
     return false;
  }
  return true;
}
//---------------------------------------------------------
int writeSerialPort(void *buffer, unsigned long numberOfBytesToWrite)
{
   BOOL           result;
   unsigned long  numberOfBytesWritten = 0;
   unsigned long  errors;
   unsigned long  lastError;
   unsigned long  bytesSent = 0;
   COMSTAT        comStat;
   OVERLAPPED     overlapped;

   result = WriteFile(hCommDev, buffer, numberOfBytesToWrite,
                      &numberOfBytesWritten, &overlapped);
   if (!result) {
      if(GetLastError() == ERROR_IO_PENDING) {
         while(!GetOverlappedResult(hCommDev,
               &overlapped,
               &numberOfBytesWritten, FALSE )) {
            lastError = GetLastError();
            if(lastError == ERROR_IO_INCOMPLETE){
               numberOfBytesWritten += bytesSent;
               continue;
            }
            else {
              ClearCommError(hCommDev, &errors, &comStat);
              break;
            }
         }
         numberOfBytesWritten += bytesSent;
      }
      else {
         ClearCommError(hCommDev, &errors, &comStat);
      }
   }
   else
      numberOfBytesWritten += bytesSent;
  FlushFileBuffers(hCommDev);
  return numberOfBytesWritten;
}
//----------------------------------------------
int readSerialPort(void *buffer, unsigned long numberOfBytesToRead)
{
   BOOL          result;
   COMSTAT       comStat ;
   unsigned long errors;
   unsigned long bytesRead = 0;
   unsigned long numberOfBytesRead = 0;
   unsigned long lastError;
   OVERLAPPED overlapped;

   ClearCommError(hCommDev, &errors, &comStat);
   bytesRead =  numberOfBytesToRead;
   if(bytesRead > 0) {
     result = ReadFile(hCommDev, buffer, bytesRead, &bytesRead,
                       &overlapped);
     if(!result) {
       if(GetLastError() == ERROR_IO_PENDING) {
          while(!GetOverlappedResult(hCommDev, &overlapped,
                &bytesRead, TRUE)) {
             lastError = GetLastError();
             if(lastError == ERROR_IO_INCOMPLETE)
             {
                numberOfBytesRead += bytesRead;
                continue;
             }
             else {
                ClearCommError(hCommDev, &errors, &comStat);
             }
              break;
          }
          numberOfBytesRead += bytesRead;
       }
     }
     else numberOfBytesRead += bytesRead;
   }
    else
       ClearCommError(hCommDev, &errors, &comStat);

   return numberOfBytesRead;
}
//---------------------------------------------------------
void closeSerialPort()
{
  if (CloseHandle(hCommDev))
    cout << "\n\nPort zosta zamknity do transmisji.\n\n";
  return;
}
//---------------------------------------------------------
